/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.s.ScoutsWarningWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class ScoutsWarningAsThoughEffect
extends AsThoughEffectImpl {
    private int zoneChangeCounter;

    public ScoutsWarningAsThoughEffect() {
        super(AsThoughEffectType.CAST_AS_INSTANT, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next creature card you play this turn can be played as though it had flash";
    }

    private ScoutsWarningAsThoughEffect(ScoutsWarningAsThoughEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        ScoutsWarningWatcher watcher = (ScoutsWarningWatcher)game.getState().getWatcher(ScoutsWarningWatcher.class, source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (watcher != null && card != null) {
            this.zoneChangeCounter = card.getZoneChangeCounter(game);
            watcher.addScoutsWarningSpell(source.getSourceId(), this.zoneChangeCounter);
        }
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ScoutsWarningAsThoughEffect copy() {
        return new ScoutsWarningAsThoughEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        ScoutsWarningWatcher watcher = (ScoutsWarningWatcher)game.getState().getWatcher(ScoutsWarningWatcher.class, source.getControllerId());
        if (watcher != null && watcher.isScoutsWarningSpellActive(source.getSourceId(), this.zoneChangeCounter)) {
            Card card = game.getCard(sourceId);
            return card != null && card.isCreature(game) && source.isControlledBy(affectedControllerId);
        }
        return false;
    }
}

