/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactCard;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ScrapMasteryEffect
extends OneShotEffect {
    ScrapMasteryEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Each player exiles all artifact cards from their graveyard, then sacrifices all artifacts they control, then puts all cards they exiled this way onto the battlefield";
    }

    private ScrapMasteryEffect(ScrapMasteryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScrapMasteryEffect copy() {
        return new ScrapMasteryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            HashMap<UUID, Set> exiledCards = new HashMap<UUID, Set>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                Set cards = player.getGraveyard().getCards((FilterCard)new FilterArtifactCard(), game);
                controller.moveCards(cards, Zone.EXILED, source, game);
                exiledCards.put(player.getId(), cards);
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterArtifactPermanent(), playerId, game)) {
                    permanent.sacrifice(source, game);
                }
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                player.moveCards((Set)exiledCards.get(playerId), Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

