/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class ScrapTrawlerTriggeredAbility
extends TriggeredAbilityImpl {
    public ScrapTrawlerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ReturnToHandTargetEffect());
        ((Effect)this.getEffects().get(0)).setText("return to your hand target artifact card in your graveyard with lesser mana value");
        this.setTriggerPhrase("Whenever {this} or another artifact you control is put into a graveyard from the battlefield, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private ScrapTrawlerTriggeredAbility(ScrapTrawlerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ScrapTrawlerTriggeredAbility copy() {
        return new ScrapTrawlerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && (permanent = ((ZoneChangeEvent)event).getTarget()) != null && permanent.isControlledBy(this.getControllerId()) && permanent.isArtifact(game)) {
            FilterArtifactCard filter = new FilterArtifactCard("artifact card in your graveyard with mana value less than " + permanent.getManaCost().manaValue());
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, permanent.getManaCost().manaValue()));
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)filter);
            this.getTargets().clear();
            this.addTarget((Target)target);
            return true;
        }
        return false;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

