/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;

class ScrapWelderCost
extends VariableCostImpl {
    public ScrapWelderCost() {
        super(VariableCostType.NORMAL, "mana value");
        this.text = "Sacrifice an artifact with mana value X";
    }

    private ScrapWelderCost(ScrapWelderCost cost) {
        super((VariableCostImpl)cost);
    }

    public ScrapWelderCost copy() {
        return new ScrapWelderCost(this);
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        FilterControlledArtifactPermanent filter = new FilterControlledArtifactPermanent("an artifact with mana value " + xValue);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, xValue));
        return new SacrificeTargetCost((FilterPermanent)filter);
    }
}

