/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.players.Player;

class ScrollOfIsildurEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    ScrollOfIsildurEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card for each tapped creature target opponent controls";
    }

    private ScrollOfIsildurEffect(ScrollOfIsildurEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScrollOfIsildurEffect copy() {
        return new ScrollOfIsildurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || opponent == null) {
            return false;
        }
        int count = game.getBattlefield().count(filter, opponent.getId(), source, game);
        return count > 0 && player.drawCards(count, source, game) > 0;
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
    }
}

