/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.abilities.mana.conditional.ConditionalSpellManaBuilder;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SeanceBoardManaEffect
extends ManaEffect {
    private static final FilterSpell filter = new FilterSpell("instant, sorcery, Demon, and Spirit spells");
    private final ConditionalManaBuilder manaBuilder = new ConditionalSpellManaBuilder(filter);

    SeanceBoardManaEffect() {
        this.staticText = "Add X mana of any one color, where X is the number of soul counters on {this}. " + this.manaBuilder.getRule();
    }

    private SeanceBoardManaEffect(SeanceBoardManaEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent != null) {
            int soulCounters = permanent.getCounters(game).getCount(CounterType.SOUL);
            netMana.add((Mana)this.manaBuilder.setMana(Mana.BlackMana((int)soulCounters), source, game).build(new Object[0]));
            netMana.add((Mana)this.manaBuilder.setMana(Mana.BlueMana((int)soulCounters), source, game).build(new Object[0]));
            netMana.add((Mana)this.manaBuilder.setMana(Mana.RedMana((int)soulCounters), source, game).build(new Object[0]));
            netMana.add((Mana)this.manaBuilder.setMana(Mana.GreenMana((int)soulCounters), source, game).build(new Object[0]));
            netMana.add((Mana)this.manaBuilder.setMana(Mana.WhiteMana((int)soulCounters), source, game).build(new Object[0]));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (controller == null || permanent == null) {
            return mana;
        }
        ChoiceColor choice = new ChoiceColor();
        if (!controller.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
            return mana;
        }
        Mana chosen = choice.getMana(permanent.getCounters(game).getCount(CounterType.SOUL));
        return (Mana)this.manaBuilder.setMana(chosen, source, game).build(new Object[0]);
    }

    public SeanceBoardManaEffect copy() {
        return new SeanceBoardManaEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate(), SubType.DEMON.getPredicate(), SubType.SPIRIT.getPredicate()}));
    }
}

