/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SearchForAzcantaEffect
extends OneShotEffect {
    SearchForAzcantaEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Then if you have seven or more cards in your graveyard, you may transform {this}.";
    }

    private SearchForAzcantaEffect(SearchForAzcantaEffect effect) {
        super((OneShotEffect)effect);
    }

    public SearchForAzcantaEffect copy() {
        return new SearchForAzcantaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        return controller != null && permanent != null && controller.getGraveyard().size() >= 7 && controller.chooseUse(this.outcome, "Transform " + permanent.getName() + '?', source, game) && permanent.transform(source, game);
    }
}

