/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.common.PlayCardTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.s.SearchTheCityExiledCardToHandEffect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class SearchTheCityTriggeredAbility
extends PlayCardTriggeredAbility {
    public SearchTheCityTriggeredAbility() {
        super(TargetController.YOU, Zone.BATTLEFIELD, (Effect)new SearchTheCityExiledCardToHandEffect(), true);
        this.setTriggerPhrase("Whenever you play a card with the same name as one of the exiled cards, ");
    }

    private SearchTheCityTriggeredAbility(SearchTheCityTriggeredAbility ability) {
        super((PlayCardTriggeredAbility)ability);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card card;
        Spell spell;
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        String cardName = "";
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getStack().getSpell(event.getTargetId())) != null) {
            cardName = spell.getName();
        }
        if (event.getType() == GameEvent.EventType.LAND_PLAYED && (card = game.getCard(event.getTargetId())) != null) {
            cardName = card.getName();
        }
        if (cardName.isEmpty()) {
            return false;
        }
        ExileZone searchTheCityExileZone = game.getExile().getExileZone(this.getSourceId());
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new NamePredicate(cardName));
        if (searchTheCityExileZone.count(filter, game) == 0) {
            return false;
        }
        ((Effect)this.getEffects().get(0)).setValue("cardName", (Object)cardName);
        return true;
    }

    public SearchTheCityTriggeredAbility copy() {
        return new SearchTheCityTriggeredAbility(this);
    }
}

