/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SearchWarrantEffect
extends OneShotEffect {
    SearchWarrantEffect() {
        super(Outcome.Exile);
        this.staticText = "Target player reveals their hand. You gain life equal to the number of cards in that player's hand";
    }

    private SearchWarrantEffect(SearchWarrantEffect effect) {
        super((OneShotEffect)effect);
    }

    public SearchWarrantEffect copy() {
        return new SearchWarrantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (player != null && targetPlayer != null) {
            targetPlayer.revealCards("Search Warrant", targetPlayer.getHand(), game);
            int ctd = targetPlayer.getHand().size();
            player.gainLife(ctd, game, source);
            return true;
        }
        return false;
    }
}

