/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SeasonOfWeavingEffect
extends OneShotEffect {
    SeasonOfWeavingEffect() {
        super(Outcome.PutCreatureInPlay);
        this.setText("Choose an artifact or creature you control. Create a token that's a copy of it");
    }

    private SeasonOfWeavingEffect(SeasonOfWeavingEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeasonOfWeavingEffect copy() {
        return new SeasonOfWeavingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetImpl target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT_OR_CREATURE).withNotTarget(true);
        if (player.choose(this.outcome, (Target)target, source, game)) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
            effect.apply(game, source);
        }
        return true;
    }
}

