/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.ElementalXXGreenToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class SeedGuardianEffect
extends OneShotEffect {
    SeedGuardianEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create an X/X green Elemental creature token, where X is the number of creature cards in your graveyard";
    }

    private SeedGuardianEffect(SeedGuardianEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeedGuardianEffect copy() {
        return new SeedGuardianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int creaturesInGraveyard = controller.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
            return new CreateTokenEffect((Token)new ElementalXXGreenToken(creaturesInGraveyard)).apply(game, source);
        }
        return false;
    }
}

