/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.effects.common.continuous.GainControlAllEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SeizeTheSpotlightEffect
extends OneShotEffect {
    SeizeTheSpotlightEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent chooses fame or fortune. For each player who chose fame, gain control of a creature that player controls until end of turn. Untap those creatures and they gain haste until end of turn. For each player who chose fortune, you draw a card and create a Treasure token";
    }

    private SeizeTheSpotlightEffect(SeizeTheSpotlightEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeizeTheSpotlightEffect copy() {
        return new SeizeTheSpotlightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Player> fame = new ArrayList<Player>();
        int fortune = 0;
        for (Object playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer((UUID)playerId);
            if (opponent == null) continue;
            boolean choseFame = opponent.chooseUse(Outcome.Detriment, "Choose fame (give a creature) or fortune (give a card and a treasure)", null, "Fame", "Fortune", source, game);
            game.informPlayers(opponent.getLogName() + " chooses " + (choseFame ? "fame" : "fortune"));
            if (choseFame) {
                fame.add(opponent);
                continue;
            }
            ++fortune;
        }
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        for (Player opponent : fame) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creature controlled by " + opponent.getName());
            filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
            TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
            target.withNotTarget(true);
            if (!target.canChoose(controller.getId(), source, game)) continue;
            controller.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            permanents.add(permanent);
        }
        if (!permanents.isEmpty()) {
            FilterPermanent affectedFilter = new FilterPermanent();
            affectedFilter.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
            new GainControlAllEffect(Duration.EndOfTurn, affectedFilter).apply(game, source);
            game.processAction();
            new UntapAllEffect(affectedFilter).apply(game, source);
            game.addEffect((ContinuousEffect)new GainAbilityAllEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn, affectedFilter), source);
        }
        if (fortune > 0) {
            controller.drawCards(fortune, source, game);
            new TreasureToken().putOntoBattlefield(fortune, game, source);
        }
        return true;
    }
}

