/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class SelectiveAdaptationEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterPermanentCard("a card to put onto the battlefield");

    SelectiveAdaptationEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top seven cards of your library. Choose from among them a card with flying, a card with first strike, and so on for double strike, deathtouch, haste, hexproof, indestructible, lifelink, menace, reach, trample, and vigilance. Put one of the chosen cards onto the battlefield, the other chosen cards into your hand, and the rest into your graveyard.";
    }

    private SelectiveAdaptationEffect(SelectiveAdaptationEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelectiveAdaptationEffect copy() {
        return new SelectiveAdaptationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl top7 = new CardsImpl(player.getLibrary().getTopCards(game, 7));
        Cards toGrave = top7.copy();
        player.revealCards(source, toGrave, game);
        CardsImpl toHand = new CardsImpl();
        if (toGrave.isEmpty()) {
            return false;
        }
        for (AbilitySelector abilitySelector : AbilitySelector.values()) {
            if (toGrave.count(abilitySelector.filter, game) < 1) continue;
            TargetCardInLibrary target = abilitySelector.makeTarget();
            player.choose(Outcome.DrawCard, (Cards)top7, (TargetCard)target, source, game);
            toHand.add((Object)target.getFirstTarget());
            toGrave.remove((Object)target.getFirstTarget());
        }
        if (toGrave.isEmpty()) {
            return false;
        }
        if (toHand.count(filter, game) > 0) {
            TargetCardInLibrary target = new TargetCardInLibrary(filter);
            player.choose(Outcome.PutCreatureInPlay, (Cards)toHand, (TargetCard)target, source, game);
            Card toBattlefield = game.getCard(target.getFirstTarget());
            if (toBattlefield != null && player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game) && Zone.BATTLEFIELD.equals((Object)game.getState().getZone(toBattlefield.getId()))) {
                toHand.remove(toBattlefield);
            }
        }
        player.moveCards((Cards)toHand, Zone.HAND, source, game);
        player.moveCards(toGrave, Zone.GRAVEYARD, source, game);
        return true;
    }

    private static enum AbilitySelector {
        FLYING(FlyingAbility.class, "flying"),
        FIRST_STRIKE(FirstStrikeAbility.class, "first strike"),
        DOUBLE_STRIKE(DoubleStrikeAbility.class, "double strike"),
        DEATHTOUCH(DeathtouchAbility.class, "deathtouch"),
        HASTE(HasteAbility.class, "haste"),
        HEXPROOF(HexproofBaseAbility.class, "hexproof"),
        INDESTRUCTIBLE(IndestructibleAbility.class, "indestructible"),
        LIFELINK(LifelinkAbility.class, "lifelink"),
        MENACE(MenaceAbility.class, "menace"),
        REACH(ReachAbility.class, "reach"),
        TRAMPLE(TrampleAbility.class, "trample"),
        VIGILANCE(VigilanceAbility.class, "vigilance");

        private final Class abilityClass;
        private final String abilityName;
        private final FilterCard filter;

        private AbilitySelector(Class abilityClass, String abilityName) {
            this.abilityClass = abilityClass;
            this.abilityName = abilityName;
            this.filter = new FilterCard("card with " + abilityName);
            this.filter.add((Predicate)new AbilityPredicate(abilityClass));
        }

        private TargetCardInLibrary makeTarget() {
            return new TargetCardInLibrary(0, 1, this.filter);
        }
    }
}

