/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SelectiveObliterationEffect
extends OneShotEffect {
    SelectiveObliterationEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player chooses a color. Then exile each permanent unless it's colorless or it's only the color its controller chose";
    }

    private SelectiveObliterationEffect(SelectiveObliterationEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelectiveObliterationEffect copy() {
        return new SelectiveObliterationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            ChoiceColor choice = new ChoiceColor(true);
            player.choose(Outcome.Exile, (Choice)choice, game);
            ObjectColor color = choice.getColor();
            game.informPlayers(player.getLogName() + " chooses " + color.getDescription());
            filter.add((Predicate)new SelectiveObliterationPredicate(playerId, choice.getColor()));
        }
        List permanents = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        return controller.moveCards((Cards)new CardsImpl(permanents), Zone.EXILED, source, game);
    }

    private static final class SelectiveObliterationPredicate
    implements Predicate<Permanent> {
        private final UUID playerId;
        private final ObjectColor color;

        SelectiveObliterationPredicate(UUID playerId, ObjectColor color) {
            this.playerId = playerId;
            this.color = color;
        }

        public boolean apply(Permanent input, Game game) {
            return !input.getColor(game).isColorless() && (!input.isControlledBy(this.playerId) || !input.getColor(game).equals((Object)this.color));
        }
    }
}

