/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class SelfDestructEffect
extends OneShotEffect {
    SelfDestructEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature you control deals X damage to any other target and X damage to itself, where X is its power";
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
    }

    private SelfDestructEffect(SelfDestructEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelfDestructEffect copy() {
        return new SelfDestructEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        List targets = this.getTargetPointer().getTargets(game, source);
        if (targets.size() < 2) {
            return false;
        }
        Permanent creature = game.getPermanent((UUID)targets.get(0));
        if (creature == null) {
            return false;
        }
        int power = creature.getPower().getValue();
        if (power < 1) {
            return false;
        }
        Permanent permanent = game.getPermanent((UUID)targets.get(1));
        if (permanent != null) {
            permanent.damage(power, creature.getId(), source, game);
        }
        if ((player = game.getPlayer((UUID)targets.get(1))) != null) {
            player.damage(power, creature.getId(), source, game);
        }
        permanent.damage(power, permanent.getId(), source, game);
        return true;
    }
}

