/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class SelfInflictedWoundEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("a green or white creature");

    SelfInflictedWoundEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target opponent sacrifices a green or white creature. If that player does, they lose 2 life";
    }

    private SelfInflictedWoundEffect(SelfInflictedWoundEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelfInflictedWoundEffect copy() {
        return new SelfInflictedWoundEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetOpponent = game.getPlayer(source.getTargets().getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (targetOpponent == null || controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)filter);
        if (target.canChoose(targetOpponent.getId(), source, game)) {
            targetOpponent.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null && permanent.sacrifice(source, game)) {
                targetOpponent.loseLife(2, game, source, false);
            }
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.GREEN), (Predicate)new ColorPredicate(ObjectColor.WHITE)));
    }
}

