/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ParleyCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SelvalasEnforcerEffect
extends OneShotEffect {
    SelvalasEnforcerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player reveals the top card of their library. For each nonland card revealed this way, put a +1/+1 counter on {this}";
    }

    private SelvalasEnforcerEffect(SelvalasEnforcerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SelvalasEnforcerEffect copy() {
        return new SelvalasEnforcerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourcePermanent;
            int parley = ParleyCount.getInstance().calculate(game, source, (Effect)this);
            if (parley > 0 && (sourcePermanent = game.getPermanent(source.getSourceId())) != null) {
                sourcePermanent.addCounters(CounterType.P1P1.createInstance(parley), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

