/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.SemestersEndReturnEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SemestersEndEffect
extends OneShotEffect {
    SemestersEndEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of target creatures and/or planeswalkers you control. At the beginning of the next end step, return each of them to the battlefield under its owner's control. Each of them enters the battlefield with an additional +1/+1 counter on it if it's a creature and an additional loyalty counter on it if it's a planeswalker";
    }

    private SemestersEndEffect(SemestersEndEffect effect) {
        super((OneShotEffect)effect);
    }

    public SemestersEndEffect copy() {
        return new SemestersEndEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SemestersEndReturnEffect((Cards)cards, game)), source);
        return true;
    }
}

