/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class SenTripletsOpponentRevealsHandEffect
extends ContinuousEffectImpl {
    SenTripletsOpponentRevealsHandEffect() {
        super(Duration.EndOfTurn, Layer.PlayerEffects, SubLayer.NA, Outcome.Detriment);
        this.staticText = "and plays with their hand revealed";
    }

    private SenTripletsOpponentRevealsHandEffect(SenTripletsOpponentRevealsHandEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            player.revealCards(player.getName() + "'s hand cards", player.getHand(), game, false);
        }
        return true;
    }

    public SenTripletsOpponentRevealsHandEffect copy() {
        return new SenTripletsOpponentRevealsHandEffect(this);
    }
}

