/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;

class SenTripletsPlayFromOpponentsHandEffect
extends AsThoughEffectImpl {
    SenTripletsPlayFromOpponentsHandEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "You may play lands and cast spells from that player's hand this turn";
    }

    private SenTripletsPlayFromOpponentsHandEffect(SenTripletsPlayFromOpponentsHandEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SenTripletsPlayFromOpponentsHandEffect copy() {
        return new SenTripletsPlayFromOpponentsHandEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Zone zone;
        Card card = game.getCard(objectId);
        if (card instanceof Spell) {
            zone = ((Spell)card).getFromZone();
        } else if (card != null) {
            zone = game.getState().getZone(card.getMainCard().getId());
        } else {
            return false;
        }
        return card.isOwnedBy(this.getTargetPointer().getFirst(game, source)) && zone == Zone.HAND && source.isControlledBy(affectedControllerId);
    }
}

