/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.s.SengirTheDarkBaronWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class SengirTheDarkBaronTriggeredAbility
extends TriggeredAbilityImpl {
    SengirTheDarkBaronTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
        this.addWatcher(new SengirTheDarkBaronWatcher());
    }

    private SengirTheDarkBaronTriggeredAbility(SengirTheDarkBaronTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SengirTheDarkBaronTriggeredAbility copy() {
        return new SengirTheDarkBaronTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        SengirTheDarkBaronWatcher watcher = (SengirTheDarkBaronWatcher)game.getState().getWatcher(SengirTheDarkBaronWatcher.class);
        if (watcher == null) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new GainLifeEffect(watcher.getLife(event.getPlayerId())));
        return true;
    }

    public String getRule() {
        return "Whenever another player loses the game, you gain life equal to that player's life total as the turn began.";
    }
}

