/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SentinelOfThePearlTridentEffect
extends OneShotEffect {
    private static final String effectText = "exile target historic permanent you control. If you do, return that card to the battlefield under its owner's control at the beginning of the next end step. <i>(Artifacts, legendaries, and Sagas are historic.)</i>";

    SentinelOfThePearlTridentEffect() {
        super(Outcome.Detriment);
        this.staticText = effectText;
    }

    private SentinelOfThePearlTridentEffect(SentinelOfThePearlTridentEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent = game.getPermanent(source.getFirstTarget());
            if (permanent != null) {
                int zcc = permanent.getZoneChangeCounter(game);
                controller.moveCards((Card)permanent, Zone.EXILED, source, game);
                ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), zcc + 1));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }

    public SentinelOfThePearlTridentEffect copy() {
        return new SentinelOfThePearlTridentEffect(this);
    }
}

