/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.common.SpellCastAllTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.s.SentinelTowerSpellsCastValue;
import mage.cards.s.SentinelTowerWatcher;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class SentinelTowerTriggeredAbility
extends SpellCastAllTriggeredAbility {
    private String damageInfo;

    SentinelTowerTriggeredAbility() {
        super((Effect)new DamageTargetEffect(0), StaticFilters.FILTER_SPELL_AN_INSTANT_OR_SORCERY, false);
        this.addTarget((Target)new TargetAnyTarget());
        this.addHint((Hint)new ValueHint("There were cast instant and sorcery this turn", (DynamicValue)SentinelTowerSpellsCastValue.instance));
        this.damageInfo = null;
    }

    private SentinelTowerTriggeredAbility(SentinelTowerTriggeredAbility effect) {
        super((SpellCastAllTriggeredAbility)effect);
        this.damageInfo = effect.damageInfo;
    }

    public SentinelTowerTriggeredAbility copy() {
        return new SentinelTowerTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.isActivePlayer(this.getControllerId()) && super.checkTrigger(event, game)) {
            SentinelTowerWatcher watcher = (SentinelTowerWatcher)game.getState().getWatcher(SentinelTowerWatcher.class);
            if (watcher == null) {
                return false;
            }
            List<MageObjectReference> spellsCast = watcher.getSpellsThisTurn();
            MageObject object = game.getObject(event.getTargetId());
            if (object == null || spellsCast == null) {
                return false;
            }
            int damageToDeal = 0;
            for (MageObjectReference mor : spellsCast) {
                ++damageToDeal;
                if (!mor.refersTo(object, game)) continue;
                break;
            }
            this.damageInfo = " (<b>" + damageToDeal + " damage</b>)";
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof DamageTargetEffect)) continue;
                ((DamageTargetEffect)effect).setAmount((DynamicValue)StaticValue.get((int)damageToDeal));
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever an instant or sorcery spell is cast during your turn, {this} deals damage to any target equal to 1 plus the number of instant and sorcery spells cast before that spell this turn." + (this.damageInfo != null ? this.damageInfo : "");
    }
}

