/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.List;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SentinelTowerWatcher
extends Watcher {
    private final List<MageObjectReference> spellsThisTurn = new ArrayList<MageObjectReference>();

    SentinelTowerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        MageObject object;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (object = game.getObject(event.getTargetId())) != null && object.isInstantOrSorcery(game)) {
            this.spellsThisTurn.add(new MageObjectReference(object, game));
        }
    }

    public void reset() {
        this.spellsThisTurn.clear();
    }

    public List<MageObjectReference> getSpellsThisTurn() {
        return this.spellsThisTurn;
    }
}

