/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.LoseAbilitySourceEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class SentryOakEffect
extends OneShotEffect {
    SentryOakEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} gets +2/+0 and loses defender until end of turn";
    }

    private SentryOakEffect(SentryOakEffect effect) {
        super((OneShotEffect)effect);
    }

    public SentryOakEffect copy() {
        return new SentryOakEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getPermanent(source.getSourceId()) != null) {
            BoostSourceEffect continuousEffect = new BoostSourceEffect(2, 0, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)continuousEffect, source);
            continuousEffect = new LoseAbilitySourceEffect((Ability)DefenderAbility.getInstance(), Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)continuousEffect, source);
            return true;
        }
        return false;
    }
}

