/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class SequesteredStashEffect
extends OneShotEffect {
    SequesteredStashEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may put an artifact card from your graveyard on top of your library";
    }

    private SequesteredStashEffect(SequesteredStashEffect effect) {
        super((OneShotEffect)effect);
    }

    public SequesteredStashEffect copy() {
        return new SequesteredStashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(StaticFilters.FILTER_CARD_ARTIFACT_FROM_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        if (target.canChoose(source.getControllerId(), source, game) && controller.chooseUse(this.outcome, "Put an artifact card from your graveyard to library?", source, game) && controller.choose(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.LIBRARY, source, game);
        }
        return true;
    }
}

