/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SereneMasterEffect
extends OneShotEffect {
    SereneMasterEffect() {
        super(Outcome.Benefit);
        this.staticText = "exchange its power and the power of target creature it's blocking until end of combat";
    }

    private SereneMasterEffect(SereneMasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public SereneMasterEffect copy() {
        return new SereneMasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceCreature = game.getPermanent(source.getSourceId());
        Permanent attackingCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourceCreature != null && attackingCreature != null) {
            StaticValue newSourcePower = StaticValue.get((int)attackingCreature.getPower().getValue());
            StaticValue newAttackerPower = StaticValue.get((int)sourceCreature.getPower().getValue());
            SetBasePowerToughnessTargetEffect effect = new SetBasePowerToughnessTargetEffect((DynamicValue)newSourcePower, null, Duration.EndOfCombat);
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            effect = new SetBasePowerToughnessTargetEffect((DynamicValue)newAttackerPower, null, Duration.EndOfCombat);
            effect.setTargetPointer((TargetPointer)new FixedTarget(attackingCreature.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

