/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class SerraParagonGainEffect
extends ContinuousEffectImpl {
    private final MageObjectReference mor;
    private final Ability ability = new DiesSourceTriggeredAbility((Effect)new ExileSourceEffect().setText("exile it")).setTriggerPhrase("When this permanent is put into a graveyard from the battlefield, ");

    SerraParagonGainEffect(MageObjectReference mor) {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.ability.addEffect((Effect)new GainLifeEffect(2).concatBy("and"));
        this.mor = mor;
    }

    private SerraParagonGainEffect(SerraParagonGainEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.ability.addEffect((Effect)new GainLifeEffect(2).concatBy("and"));
        this.mor = effect.mor;
    }

    public SerraParagonGainEffect copy() {
        return new SerraParagonGainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (this.mor.getZoneChangeCounter() + 1 < game.getState().getZoneChangeCounter(this.mor.getSourceId())) {
            this.discard();
            return false;
        }
        Spell spell = game.getSpell(this.mor.getSourceId());
        if (spell != null) {
            game.getState().addOtherAbility(spell.getCard(), this.ability);
            return true;
        }
        Permanent permanent = game.getPermanent(this.mor.getSourceId());
        if (permanent != null) {
            permanent.addAbility(this.ability, source.getSourceId(), game);
            return true;
        }
        return false;
    }
}

