/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SerrasEmissaryEffect
extends ContinuousEffectImpl {
    SerrasEmissaryEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "you and creatures you control have protection from the chosen card type";
    }

    private SerrasEmissaryEffect(SerrasEmissaryEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Object savedType = game.getState().getValue(source.getSourceId() + "_type");
        if (controller == null || savedType == null) {
            return false;
        }
        if (savedType instanceof String) {
            CardType cardType = CardType.fromString((String)((String)savedType));
            FilterCard filter = new FilterCard(cardType + "s");
            filter.add((Predicate)cardType.getPredicate());
            ProtectionAbility ability = new ProtectionAbility((Filter)filter);
            controller.addAbility((Ability)ability);
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
                permanent.addAbility((Ability)ability, source.getSourceId(), game);
            }
            return true;
        }
        return false;
    }

    public SerrasEmissaryEffect copy() {
        return new SerrasEmissaryEffect(this);
    }
}

