/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class SeverancePriestEffect
extends OneShotEffect {
    SeverancePriestEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent reveals their hand. You may choose a nonland card from it. If you do, exile that card";
    }

    private SeverancePriestEffect(SeverancePriestEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeverancePriestEffect copy() {
        return new SeverancePriestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null || opponent.getHand().isEmpty()) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        controller.choose(Outcome.Discard, opponent.getHand(), target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && controller.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
    }
}

