/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class SevinneTheChronoclasmWatcher
extends Watcher {
    private final Map<UUID, UUID> firstSpellThisTurn = new HashMap<UUID, UUID>();

    SevinneTheChronoclasmWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST || event.getZone() != Zone.GRAVEYARD) {
            return;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.isInstantOrSorcery(game)) {
            this.firstSpellThisTurn.putIfAbsent(event.getPlayerId(), spell.getId());
        }
    }

    public void reset() {
        this.firstSpellThisTurn.clear();
    }

    boolean checkFirstSpellThisTurn(UUID playerId, UUID targetId) {
        return targetId != null && targetId.equals(this.firstSpellThisTurn.getOrDefault(playerId, null));
    }
}

