/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class ShadowMysteriousAssassinEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent("another nonland permanent");

    ShadowMysteriousAssassinEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another nonland permanent. If you do, draw two cards and each opponent loses life equal to the mana value of the sacrificed permanent";
    }

    private ShadowMysteriousAssassinEffect(ShadowMysteriousAssassinEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShadowMysteriousAssassinEffect copy() {
        return new ShadowMysteriousAssassinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, 1, filter);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        int mv = permanent.getManaValue();
        player.drawCards(2, source, game);
        if (mv < 1) {
            return true;
        }
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Optional.ofNullable(opponentId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(opponent -> opponent.loseLife(mv, game, source, false));
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

