/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.CardsCycledOrDiscardedThisTurnWatcher;

class ShadowOfTheGraveEffect
extends OneShotEffect {
    ShadowOfTheGraveEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return to your hand all cards in your graveyard that you cycled or discarded this turn";
    }

    private ShadowOfTheGraveEffect(ShadowOfTheGraveEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShadowOfTheGraveEffect copy() {
        return new ShadowOfTheGraveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsCycledOrDiscardedThisTurnWatcher watcher = (CardsCycledOrDiscardedThisTurnWatcher)game.getState().getWatcher(CardsCycledOrDiscardedThisTurnWatcher.class);
        if (controller != null && watcher != null) {
            for (Card card : watcher.getCardsCycledOrDiscardedThisTurn(controller.getId()).getCards(game)) {
                if (game.getState().getZone(card.getId()) != Zone.GRAVEYARD || !card.isOwnedBy(controller.getId())) continue;
                controller.moveCardToHandWithInfo(card, source, game, true);
            }
            return true;
        }
        return false;
    }
}

