/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShadrixSilverquillEffect
extends OneShotEffect {
    ShadrixSilverquillEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player puts a +1/+1 counter on each creature they control";
    }

    private ShadrixSilverquillEffect(ShadrixSilverquillEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShadrixSilverquillEffect copy() {
        return new ShadrixSilverquillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getPlayer(source.getFirstTarget()) == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getFirstTarget(), source, game)) {
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getFirstTarget(), source, game);
        }
        return true;
    }
}

