/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShapeshifterContinuousEffect
extends ContinuousEffectImpl {
    ShapeshifterContinuousEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.CharacteristicDefining_7a, Outcome.BoostCreature);
        this.staticText = "{this}'s power is equal to the last chosen number and its toughness is equal to 7 minus that number.";
    }

    private ShapeshifterContinuousEffect(ShapeshifterContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ShapeshifterContinuousEffect copy() {
        return new ShapeshifterContinuousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        String lastChosen = (String)game.getState().getValue(source.getSourceId().toString() + "_Shapeshifter");
        if (permanent != null && lastChosen != null) {
            int lastChosenNumber = Integer.parseInt(lastChosen);
            permanent.getPower().setModifiedBaseValue(lastChosenNumber);
            permanent.getToughness().setModifiedBaseValue(7 - lastChosenNumber);
            return true;
        }
        return false;
    }
}

