/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.s.ShareTheSpoilsWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class ShareTheSpoilsPlayExiledCardEffect
extends AsThoughEffectImpl {
    ShareTheSpoilsPlayExiledCardEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.PutCardInPlay);
        this.staticText = "During each player's turn, that player may play a land or cast a spell from among cards exiled with {this}, and they may spend mana as though it were mana of any color to cast that spell. When they do, exile the top card of their library.";
    }

    private ShareTheSpoilsPlayExiledCardEffect(ShareTheSpoilsPlayExiledCardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!game.getActivePlayerId().equals(affectedControllerId)) {
            return false;
        }
        if (game.getState().getZone(CardUtil.getMainCardId((Game)game, (UUID)sourceId)) != Zone.EXILED) {
            return false;
        }
        int zoneChangeCounter = game.getState().getZoneChangeCounter(source.getSourceId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)zoneChangeCounter));
        if (exileZone == null) {
            return false;
        }
        if (!exileZone.contains((Object)CardUtil.getMainCardId((Game)game, (UUID)sourceId))) {
            return false;
        }
        ShareTheSpoilsWatcher watcher = (ShareTheSpoilsWatcher)game.getState().getWatcher(ShareTheSpoilsWatcher.class);
        if (watcher == null) {
            return false;
        }
        return watcher.hasNotUsedAbilityThisTurn();
    }

    public ShareTheSpoilsPlayExiledCardEffect copy() {
        return new ShareTheSpoilsPlayExiledCardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }
}

