/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SharkeyTyrantOfTheShireReplacementEffect
extends ReplacementEffectImpl {
    private FilterPermanent filter;

    SharkeyTyrantOfTheShireReplacementEffect(FilterPermanent filter) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.filter = filter;
        this.staticText = "Activated abilities of lands your opponents control can't be activated unless they're mana abilities";
    }

    private SharkeyTyrantOfTheShireReplacementEffect(SharkeyTyrantOfTheShireReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.filter = effect.filter;
    }

    public SharkeyTyrantOfTheShireReplacementEffect copy() {
        return new SharkeyTyrantOfTheShireReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Optional ability;
        MageObject object = game.getObject(event.getSourceId());
        return object instanceof Permanent && this.filter.match((Permanent)object, source.getControllerId(), source, game) && (ability = object.getAbilities().get(event.getTargetId())).isPresent() && !((Ability)ability.get()).isManaActivatedAbility();
    }
}

