/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.filter.predicate.mageobject.MulticoloredPredicate;
import mage.game.Game;
import mage.players.Player;

class ShatterAssumptionsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterNonlandCard("colorless nonland");
    private static final FilterCard filter2 = new FilterCard("multicolored");
    private final boolean colorless;

    ShatterAssumptionsEffect(boolean colorless) {
        super(Outcome.Benefit);
        this.colorless = colorless;
        this.staticText = colorless ? "Target opponent reveals their hand and discards all colorless nonland cards." : "Target opponent reveals their hand and discards all multicolored cards.";
    }

    private ShatterAssumptionsEffect(ShatterAssumptionsEffect effect) {
        super((OneShotEffect)effect);
        this.colorless = effect.colorless;
    }

    public ShatterAssumptionsEffect copy() {
        return new ShatterAssumptionsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        player.revealCards(source, player.getHand(), game);
        FilterCard f = this.colorless ? filter : filter2;
        player.discard((Cards)new CardsImpl(player.getHand().getCards(f, game)), false, source, game);
        return true;
    }

    static {
        filter.add((Predicate)ColorlessPredicate.instance);
        filter2.add((Predicate)MulticoloredPredicate.instance);
    }
}

