/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

class ShattergangBrothersEffect
extends OneShotEffect {
    private final FilterPermanent filter;

    ShattergangBrothersEffect(FilterPermanent filter) {
        super(Outcome.Sacrifice);
        this.filter = filter;
        this.staticText = "Each other player sacrifices " + CardUtil.addArticle((String)filter.getMessage());
    }

    private ShattergangBrothersEffect(ShattergangBrothersEffect effect) {
        super((OneShotEffect)effect);
        this.filter = effect.filter;
    }

    public ShattergangBrothersEffect copy() {
        return new ShattergangBrothersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Permanent permanent;
                TargetSacrifice target;
                Player player;
                if (Objects.equals(playerId, source.getControllerId()) || (player = game.getPlayer(playerId)) == null || !(target = new TargetSacrifice(this.filter)).canChoose(playerId, source, game) || !player.chooseTarget(this.outcome, (Target)target, source, game) || (permanent = game.getPermanent(target.getFirstTarget())) == null) continue;
                permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }
}

