/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.AttacksWithCreaturesTriggeredAbility;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public class ShaunFatherOfSynths
extends CardImpl {
    private static final FilterControlledCreaturePermanent attackFilter = new FilterControlledCreaturePermanent("attacking legendary creature you control other than {this}");
    private static final FilterControlledPermanent exileFilter = new FilterControlledPermanent(SubType.SYNTH, "Synth tokens you control");

    public ShaunFatherOfSynths(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{U}{R}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.SCIENTIST);
        this.power = new MageInt(3);
        this.toughness = new MageInt(4);
        OneShotEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, true, true).setPermanentModifier(token -> {
            token.removeSuperType(SuperType.LEGENDARY);
            token.addCardType(new CardType[]{CardType.CREATURE});
            token.addCardType(new CardType[]{CardType.ARTIFACT});
            token.addSubType(new SubType[]{SubType.SYNTH});
        }).setText("create a tapped and attacking token that's a copy of target attacking legendary creature you control other than {this}, except it's not legendary and it's a Synth artifact creature in addition to its other types");
        AttacksWithCreaturesTriggeredAbility ability = new AttacksWithCreaturesTriggeredAbility(Zone.BATTLEFIELD, (Effect)effect, 1, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, false, true);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)attackFilter));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new LeavesBattlefieldTriggeredAbility((Effect)new ExileAllEffect((FilterPermanent)exileFilter), false));
    }

    private ShaunFatherOfSynths(ShaunFatherOfSynths card) {
        super((CardImpl)card);
    }

    public ShaunFatherOfSynths copy() {
        return new ShaunFatherOfSynths(this);
    }

    static {
        attackFilter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        attackFilter.add((Predicate)AttackingPredicate.instance);
        attackFilter.add((Predicate)SuperType.LEGENDARY.getPredicate());
        exileFilter.add((Predicate)TokenPredicate.TRUE);
    }
}

