/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponentsCreaturePermanent;

class ShelteringAncientCost
extends CostImpl {
    ShelteringAncientCost() {
        this.text = "Put a +1/+1 counter on a creature an opponent controls";
    }

    private ShelteringAncientCost(ShelteringAncientCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            Permanent permanent;
            TargetOpponentsCreaturePermanent target = new TargetOpponentsCreaturePermanent();
            target.withNotTarget(true);
            if (target.choose(Outcome.BoostCreature, controllerId, source.getSourceId(), source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                permanent.addCounters(CounterType.P1P1.createInstance(), controllerId, ability, game);
                this.paid = true;
                return true;
            }
        }
        return false;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE, source, game, 1);
    }

    public ShelteringAncientCost copy() {
        return new ShelteringAncientCost(this);
    }
}

