/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.TargetHasCounterCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public class ShieldBroker
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("noncommander creature you don't control");

    public ShieldBroker(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{U}{U}");
        this.addSubType(new SubType[]{SubType.OCTOPUS, SubType.ADVISOR});
        this.power = new MageInt(3);
        this.toughness = new MageInt(4);
        EntersBattlefieldTriggeredAbility etbAbility = new EntersBattlefieldTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.SHIELD.createInstance()));
        GainControlTargetEffect gainControlEffect = new GainControlTargetEffect(Duration.Custom, false, null, (Condition)new TargetHasCounterCondition(CounterType.SHIELD));
        gainControlEffect.setText("You gain control of that creature for as long as it has a shield counter on it. <i>(If it would be dealt damage or destroyed, remove a shield counter from it instead.)</i>");
        etbAbility.addEffect((Effect)gainControlEffect);
        etbAbility.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.addAbility((Ability)etbAbility);
    }

    private ShieldBroker(ShieldBroker card) {
        super((CardImpl)card);
    }

    public ShieldBroker copy() {
        return new ShieldBroker(this);
    }

    static {
        filter.add(Predicates.not((Predicate)CommanderPredicate.instance));
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
    }
}

