/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldAllTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SetTargetPointer;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class ShieldedByFaith
extends CardImpl {
    public ShieldedByFaith(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{W}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.Benefit));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        GainAbilityAttachedEffect effect = new GainAbilityAttachedEffect((Ability)IndestructibleAbility.getInstance(), AttachmentType.AURA, Duration.WhileOnBattlefield);
        effect.setText("Enchanted creature has indestructible");
        effect.setOutcome(Outcome.Benefit);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effect));
        this.addAbility((Ability)new EntersBattlefieldAllTriggeredAbility(Zone.BATTLEFIELD, (Effect)new AttachEffect(Outcome.AIDontUseIt, "attach {this} to that creature"), (FilterPermanent)StaticFilters.FILTER_PERMANENT_A_CREATURE, true, SetTargetPointer.PERMANENT));
    }

    private ShieldedByFaith(ShieldedByFaith card) {
        super((CardImpl)card);
    }

    public ShieldedByFaith copy() {
        return new ShieldedByFaith(this);
    }
}

