/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.s.ShiftingShadowEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShiftingShadowGainEffect
extends ContinuousEffectImpl {
    ShiftingShadowGainEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "enchanted creature has haste and \"At the beginning of your upkeep, destroy this creature. Reveal cards from the top of your library until you reveal a creature card. Put that card onto the battlefield and attach {this} to it, then put all other cards revealed this way on the bottom of your library in a random order.\"";
    }

    private ShiftingShadowGainEffect(ShiftingShadowGainEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ShiftingShadowGainEffect copy() {
        return new ShiftingShadowGainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent aura = source.getSourcePermanentIfItStillExists(game);
        if (aura == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(aura.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        permanent.addAbility((Ability)HasteAbility.getInstance(), source.getSourceId(), game);
        permanent.addAbility((Ability)new BeginningOfUpkeepTriggeredAbility((Effect)new ShiftingShadowEffect(aura, game)), source.getSourceId(), game);
        return true;
    }
}

