/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShiftyDoppelgangerReturnEffect
extends OneShotEffect {
    private final MageObjectReference creatureMor;
    private final MageObjectReference sourceMor;

    ShiftyDoppelgangerReturnEffect(Permanent creature, Ability source, Game game) {
        super(Outcome.Benefit);
        this.staticText = "sacrifice that creature. If you do, return {this} to the battlefield";
        this.creatureMor = new MageObjectReference((MageObject)creature, game);
        this.sourceMor = new MageObjectReference(source, 1);
    }

    private ShiftyDoppelgangerReturnEffect(ShiftyDoppelgangerReturnEffect effect) {
        super((OneShotEffect)effect);
        this.creatureMor = effect.creatureMor;
        this.sourceMor = effect.sourceMor;
    }

    public ShiftyDoppelgangerReturnEffect copy() {
        return new ShiftyDoppelgangerReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = this.creatureMor.getPermanent(game);
        Player player = game.getPlayer(source.getControllerId());
        if (creature == null || player == null || !creature.sacrifice(source, game)) {
            return false;
        }
        Card sourceCard = this.sourceMor.getCard(game);
        if (sourceCard != null) {
            player.moveCards(sourceCard, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

