/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class ShimianNightStalkerRedirectDamageEffect
extends RedirectionEffect {
    private static FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public ShimianNightStalkerRedirectDamageEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, RedirectionEffect.UsageType.ACCORDING_DURATION);
        this.staticText = "All damage that would be dealt to you this turn by target attacking creature is dealt to {this} instead";
    }

    private ShimianNightStalkerRedirectDamageEffect(ShimianNightStalkerRedirectDamageEffect effect) {
        super((RedirectionEffect)effect);
    }

    public ShimianNightStalkerRedirectDamageEffect copy() {
        return new ShimianNightStalkerRedirectDamageEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && filter.match(permanent, permanent.getControllerId(), source, game) && event.getSourceId() != null && event.getTargetId() != null && event.getSourceId().equals(this.getTargetPointer().getFirst(game, source)) && event.getTargetId().equals(source.getControllerId())) {
            TargetPermanent target = new TargetPermanent();
            target.add(source.getSourceId(), game);
            this.redirectTarget = target;
            return true;
        }
        return false;
    }
}

