/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetSource;

class ShiningShoalRedirectDamageTargetEffect
extends RedirectionEffect {
    private final DynamicValue dynamicAmount;
    private MageObjectReference mageObjectReference;

    public ShiningShoalRedirectDamageTargetEffect(Duration duration, DynamicValue dynamicAmount) {
        super(duration, 0, RedirectionEffect.UsageType.ONE_USAGE_AT_THE_SAME_TIME);
        this.dynamicAmount = dynamicAmount;
        this.staticText = "The next X damage that a source of your choice would deal to you and/or creatures you control this turn is dealt to any target instead";
    }

    private ShiningShoalRedirectDamageTargetEffect(ShiningShoalRedirectDamageTargetEffect effect) {
        super((RedirectionEffect)effect);
        this.dynamicAmount = effect.dynamicAmount;
        this.mageObjectReference = effect.mageObjectReference;
    }

    public ShiningShoalRedirectDamageTargetEffect copy() {
        return new ShiningShoalRedirectDamageTargetEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.amountToRedirect = this.dynamicAmount.calculate(game, source, (Effect)this);
        TargetSource target = new TargetSource();
        target.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
        this.mageObjectReference = new MageObjectReference(target.getFirstTarget(), game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && event.getFlag()) {
            MageObject sourceObject = game.getObject(event.getSourceId());
            if (sourceObject == null) {
                game.informPlayers("Couldn't find source of damage");
                return false;
            }
            if (!this.mageObjectReference.refersTo(sourceObject, game)) {
                return false;
            }
            Permanent permanent = game.getPermanent(event.getTargetId());
            if (permanent != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId())) {
                this.redirectTarget = (Target)source.getTargets().get(0);
                return true;
            }
            Player player = game.getPlayer(event.getTargetId());
            if (player != null && player.getId().equals(source.getControllerId())) {
                this.redirectTarget = (Target)source.getTargets().get(0);
                return true;
            }
        }
        return false;
    }
}

