/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DefenderAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShoalSerpentEffect
extends ContinuousEffectImpl {
    ShoalSerpentEffect() {
        super(Duration.EndOfTurn, Outcome.AddAbility);
        this.staticText = "{this} loses defender until end of turn";
    }

    private ShoalSerpentEffect(ShoalSerpentEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ShoalSerpentEffect copy() {
        return new ShoalSerpentEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            switch (layer) {
                case AbilityAddingRemovingEffects_6: {
                    if (sublayer != SubLayer.NA) break;
                    permanent.removeAbility((Ability)DefenderAbility.getInstance(), source.getSourceId(), game);
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

