/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ShorecrasherElementalBoostEffect
extends OneShotEffect {
    private static String CHOICE_1 = "+1/-1";
    private static String CHOICE_2 = "-1/+1";

    public ShorecrasherElementalBoostEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} gets +1/-1 or -1/+1 until end of turn";
    }

    private ShorecrasherElementalBoostEffect(ShorecrasherElementalBoostEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShorecrasherElementalBoostEffect copy() {
        return new ShorecrasherElementalBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Select how to boost");
            choice.getChoices().add(CHOICE_1);
            choice.getChoices().add(CHOICE_2);
            if (controller.choose(this.outcome, (Choice)choice, game)) {
                if (choice.getChoice().equals(CHOICE_1)) {
                    game.addEffect((ContinuousEffect)new BoostSourceEffect(1, -1, Duration.EndOfTurn), source);
                } else {
                    game.addEffect((ContinuousEffect)new BoostSourceEffect(-1, 1, Duration.EndOfTurn), source);
                }
                return true;
            }
        }
        return false;
    }
}

