/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ShowOfDominanceEffect
extends OneShotEffect {
    ShowOfDominanceEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Put four +1/+1 counters on the creature with the highest power. If two or more creatures are tied for the greatest power, you choose one of them. That creature gains trample until end of turn";
    }

    private ShowOfDominanceEffect(ShowOfDominanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShowOfDominanceEffect copy() {
        return new ShowOfDominanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int highestPower = Integer.MIN_VALUE;
            Permanent selectedCreature = null;
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game)) {
                if (highestPower < permanent.getPower().getValue()) {
                    highestPower = permanent.getPower().getValue();
                    selectedCreature = permanent;
                    continue;
                }
                if (highestPower != permanent.getPower().getValue()) continue;
                highestPower = permanent.getPower().getValue();
                selectedCreature = null;
            }
            if (highestPower != Integer.MIN_VALUE) {
                if (selectedCreature == null) {
                    FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with power " + highestPower);
                    filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, highestPower));
                    TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
                    if (controller.chooseTarget(this.outcome, (Target)target, source, game)) {
                        selectedCreature = game.getPermanent(target.getFirstTarget());
                    }
                }
                if (selectedCreature != null) {
                    FixedTarget blueprintTarget = new FixedTarget(selectedCreature.getId(), game);
                    AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(4));
                    effect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                    effect.apply(game, source);
                    GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
                    continuousEffect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                    game.addEffect((ContinuousEffect)continuousEffect, source);
                    return true;
                }
            }
            return true;
        }
        return false;
    }
}

